#rem
'CleverLoad Program

'HARDWARE
'CleverLoad main board Ver1.3a and display board Ver1.0
'All circuitry must be working before using this program.
'PCB hardware debug should use test scripts specific to hardware being debugged

'WHAT IT DOES
'  1) Measures RF Power...I suppose I could embelish this.
'	  		
'DOWNLOAD
'There is no reset function on the 20X2 & this unit employs a soft power switch
'To download if the unit is off skip steps 1 and 2
'1) Turn unit's power supply off, wait a few seconds for all caps to discharge
'2) Turn unit's power supply back on, the unit must remain off. 
'3) Start the download process on the PC, 
'4) When the 'Connecting to hardware...' window appears push S3, the button below
'   the display and keep it held down until programming is complete. 
#endrem

'Load EEPROM data 'note this data must come first or compiler bitches
'########################################################
'EEPROM data for 0 to -10dBm correction
EEPROM 0,(0)
EEPROM   	0	,	(	0	)
EEPROM	1	,	(	0	)
EEPROM	2	,	(	0	)
EEPROM	3	,	(	0	)
EEPROM	4	,	(	0	)
EEPROM	5	,	(	0	)
EEPROM	6	,	(	0	)
EEPROM	7	,	(	0	)
EEPROM	8	,	(	0	)
EEPROM	9	,	(	0	)
EEPROM	10	,	(	0	)
EEPROM	11	,	(	0	)
EEPROM	12	,	(	0	)
EEPROM	13	,	(	0	)
EEPROM	14	,	(	0	)
EEPROM	15	,	(	0	)
EEPROM	16	,	(	0	)
EEPROM	17	,	(	0	)
EEPROM	18	,	(	0	)
EEPROM	19	,	(	0	)
EEPROM	20	,	(	0	)
EEPROM	21	,	(	0	)
EEPROM	22	,	(	0	)
EEPROM	23	,	(	83	)
EEPROM	24	,	(	83	)
EEPROM	25	,	(	83	)
EEPROM	26	,	(	83	)
EEPROM	27	,	(	83	)
EEPROM	28	,	(	83	)
EEPROM	29	,	(	83	)
EEPROM	30	,	(	83	)
EEPROM	31	,	(	83	)
EEPROM	32	,	(	84	)
EEPROM	33	,	(	84	)
EEPROM	34	,	(	84	)
EEPROM	35	,	(	84	)
EEPROM	36	,	(	84	)
EEPROM	37	,	(	84	)
EEPROM	38	,	(	84	)
EEPROM	39	,	(	84	)
EEPROM	40	,	(	86	)
EEPROM	41	,	(	86	)
EEPROM	42	,	(	86	)
EEPROM	43	,	(	86	)
EEPROM	44	,	(	86	)
EEPROM	45	,	(	86	)
EEPROM	46	,	(	87	)
EEPROM	47	,	(	87	)
EEPROM	48	,	(	87	)
EEPROM	49	,	(	87	)
EEPROM	50	,	(	88	)
EEPROM	51	,	(	88	)
EEPROM	52	,	(	88	)
EEPROM	53	,	(	88	)
EEPROM	54	,	(	88	)
EEPROM	55	,	(	89	)
EEPROM	56	,	(	89	)
EEPROM	57	,	(	89	)
EEPROM	58	,	(	90	)
EEPROM	59	,	(	90	)
EEPROM	60	,	(	90	)
EEPROM	61	,	(	92	)
EEPROM	62	,	(	92	)
EEPROM	63	,	(	92	)
EEPROM	64	,	(	93	)
EEPROM	65	,	(	93	)
EEPROM	66	,	(	94	)
EEPROM	67	,	(	94	)
EEPROM	68	,	(	94	)
EEPROM	69	,	(	96	)
EEPROM	70	,	(	96	)
EEPROM	71	,	(	97	)
EEPROM	72	,	(	97	)
EEPROM	73	,	(	97	)
EEPROM	74	,	(	98	)
EEPROM	75	,	(	98	)
EEPROM	76	,	(	99	)
EEPROM	77	,	(	99	)
EEPROM	78	,	(	101	)
EEPROM	79	,	(	101	)
EEPROM	80	,	(	102	)
EEPROM	81	,	(	102	)
EEPROM	82	,	(	103	)
EEPROM	83	,	(	103	)
EEPROM	84	,	(	104	)
EEPROM	85	,	(	104	)
EEPROM	86	,	(	106	)
EEPROM	87	,	(	106	)
EEPROM	88	,	(	107	)
EEPROM	89	,	(	107	)
EEPROM	90	,	(	108	)
EEPROM	91	,	(	108	)
EEPROM	92	,	(	109	)
EEPROM	93	,	(	109	)
EEPROM	94	,	(	111	)
EEPROM	95	,	(	111	)
EEPROM	96	,	(	112	)
EEPROM	97	,	(	112	)
EEPROM	98	,	(	113	)
EEPROM	99	,	(	113	)
EEPROM	100	,	(	114	)
EEPROM	101	,	(	114	)
EEPROM	102	,	(	116	)
EEPROM	103	,	(	117	)
EEPROM	104	,	(	117	)
EEPROM	105	,	(	119	)
EEPROM	106	,	(	119	)
EEPROM	107	,	(	119	)
EEPROM	108	,	(	120	)
EEPROM	109	,	(	120	)
EEPROM	110	,	(	122	)
EEPROM	111	,	(	122	)
EEPROM	112	,	(	123	)
EEPROM	113	,	(	123	)
EEPROM	114	,	(	124	)
EEPROM	115	,	(	126	)
EEPROM	116	,	(	126	)
EEPROM	117	,	(	127	)
EEPROM	118	,	(	128	)
EEPROM	119	,	(	128	)
EEPROM	120	,	(	129	)
EEPROM	121	,	(	129	)
EEPROM	122	,	(	131	)
EEPROM	123	,	(	132	)
EEPROM	124	,	(	132	)
EEPROM	125	,	(	133	)
EEPROM	126	,	(	133	)
EEPROM	127	,	(	134	)
EEPROM	128	,	(	134	)
EEPROM	129	,	(	136	)
EEPROM	130	,	(	137	)
EEPROM	131	,	(	137	)
EEPROM	132	,	(	138	)
EEPROM	133	,	(	138	)
EEPROM	134	,	(	139	)
EEPROM	135	,	(	139	)
EEPROM	136	,	(	141	)
EEPROM	137	,	(	142	)
EEPROM	138	,	(	142	)
EEPROM	139	,	(	143	)
EEPROM	140	,	(	144	)
EEPROM	141	,	(	144	)
EEPROM	142	,	(	146	)
EEPROM	143	,	(	147	)
EEPROM	144	,	(	147	)
EEPROM	145	,	(	148	)
EEPROM	146	,	(	149	)
EEPROM	147	,	(	150	)
EEPROM	148	,	(	151	)
EEPROM	149	,	(	152	)
EEPROM	150	,	(	152	)
EEPROM	151	,	(	153	)
EEPROM	152	,	(	154	)
EEPROM	153	,	(	155	)
EEPROM	154	,	(	155	)
EEPROM	155	,	(	157	)
EEPROM	156	,	(	158	)
EEPROM	157	,	(	159	)
EEPROM	158	,	(	159	)
EEPROM	159	,	(	161	)
EEPROM	160	,	(	162	)
EEPROM	161	,	(	163	)
EEPROM	162	,	(	163	)
EEPROM	163	,	(	164	)
EEPROM	164	,	(	165	)
EEPROM	165	,	(	167	)
EEPROM	166	,	(	167	)
EEPROM	167	,	(	168	)
EEPROM	168	,	(	168	)
EEPROM	169	,	(	170	)
EEPROM	170	,	(	172	)
EEPROM	171	,	(	172	)
EEPROM	172	,	(	173	)
EEPROM	173	,	(	174	)
EEPROM	174	,	(	175	)
EEPROM	175	,	(	177	)
EEPROM	176	,	(	178	)
EEPROM	177	,	(	179	)
EEPROM	178	,	(	179	)
EEPROM	179	,	(	180	)
EEPROM	180	,	(	182	)
EEPROM	181	,	(	183	)
EEPROM	182	,	(	184	)
EEPROM	183	,	(	184	)
EEPROM	184	,	(	185	)
EEPROM	185	,	(	187	)
EEPROM	186	,	(	188	)
EEPROM	187	,	(	188	)
EEPROM	188	,	(	189	)
EEPROM	189	,	(	190	)
EEPROM	190	,	(	190	)
EEPROM	191	,	(	192	)
EEPROM	192	,	(	193	)
EEPROM	193	,	(	194	)
EEPROM	194	,	(	196	)
EEPROM	195	,	(	196	)
EEPROM	196	,	(	197	)
EEPROM	197	,	(	198	)
EEPROM	198	,	(	199	)
EEPROM	199	,	(	201	)
EEPROM	200	,	(	201	)
EEPROM	201	,	(	202	)
EEPROM	202	,	(	203	)
EEPROM	203	,	(	204	)
EEPROM	204	,	(	204	)
EEPROM	205	,	(	205	)
EEPROM	206	,	(	207	)
EEPROM	207	,	(	208	)
EEPROM	208	,	(	208	)
EEPROM	209	,	(	209	)
EEPROM	210	,	(	210	)
EEPROM	211	,	(	211	)
EEPROM	212	,	(	212	)
EEPROM	213	,	(	213	)
EEPROM	214	,	(	214	)
EEPROM	215	,	(	215	)
EEPROM	216	,	(	216	)
EEPROM	217	,	(	217	)
EEPROM	218	,	(	218	)
EEPROM	219	,	(	219	)
EEPROM	220	,	(	220	)
EEPROM	221	,	(	221	)
EEPROM	222	,	(	222	)
EEPROM	223	,	(	223	)
EEPROM	224	,	(	224	)
EEPROM	225	,	(	225	)
EEPROM	226	,	(	226	)
EEPROM	227	,	(	227	)
EEPROM	228	,	(	228	)
EEPROM	229	,	(	229	)
EEPROM	230	,	(	230	)
EEPROM	231	,	(	231	)
EEPROM	232	,	(	232	)
EEPROM	233	,	(	233	)
EEPROM	234	,	(	234	)
EEPROM	235	,	(	235	)
EEPROM	236	,	(	236	)
EEPROM	237	,	(	237	)
EEPROM	238	,	(	238	)
EEPROM	239	,	(	239	)
EEPROM	240	,	(	240	)
EEPROM	241	,	(	241	)
EEPROM	242	,	(	242	)
EEPROM	243	,	(	243	)
EEPROM	244	,	(	244	)
EEPROM	245	,	(	245	)
EEPROM	246	,	(	246	)
EEPROM	247	,	(	247	)
EEPROM	248	,	(	248	)
EEPROM	249	,	(	249	)
EEPROM	250	,	(	250	)
EEPROM	251	,	(	251	)
EEPROM	252	,	(	252	)
EEPROM	253	,	(	253	)
EEPROM	254	,	(	254	)
EEPROM	255	,	(	255	)
'End EEPROM data
'#######################################################

variables:'used by CleverLoad 
  symbol intvcc=c.1		'switched internal V+ high=off
  symbol gainvcc=b.2		'switched internal for 8x gain block high=off
  symbol bklite=c.5		'display backlight high=off
  symbol wpEEPROM=b.4		'Write Protect 24LC256 lo=write enable
  symbol shdn=c.2			'regulator shutdown low=shutdown
  symbol fan=c.4			'fan switch high=off
  symbol sw1=pinb.6		'menu switch 1 to 20X2 leg 4 -top button
  symbol sw2=pinc.0		'menu switch 2 to 20X2 leg 10 -middle button
  symbol sw3=pinc.6		'menu switch 3 to 20X2 leg 1 -lower button
  symbol EscapeTempAlarm=b0	'used to bypass temperature alarm
  symbol MainMenuItem=b1	'keeps track of main menu current location
  symbol SubMenuItem=b2		'keeps track of utility menu current location
  symbol var1=b3			'generic variable leased by subroutines
  symbol var2=b4			'generic variable leased by subroutines
  symbol var3=b5			'used across many routines to flag negative no.
  symbol unit=b6			'used to parse numbers for display units
  symbol ten=b7			'used to parse numbers for display tens
  symbol hundred=b8		'used to parse numbers for display hundreds
  symbol thousand=b9		'used to parse numbers for display thousands
  symbol TurnOffInterval=b10	'valu sets unit turn off time if no switches pushed
  symbol OffTime=b11		'contains updated turnoff time if any switch pushed
  symbol PowerSymbol=b12	'shows power source battery level symbol
  symbol range=b13		'used in bargraph display
  symbol rangelo=w7		'used in bargraph display b14 & b15
  symbol rangehi=w8		'used in bargraph display b15 & b16
  symbol Temp=b18			'stores temperature 
  symbol TempThreshMinusHysteresis=b19'saves TempThreshold minus Hysteresis
  symbol varw10=w10		'Word generic variable leased by subroutines
  symbol varw11=w11		'Word generic variable leased by subroutines
  symbol varw12=w12		'Word generic variable leased by subroutines
  symbol varw13=w13		'Word generic variable leased by subroutines
  symbol dBm=w14			'curreent value of power reading in dBm
  'b30-b37 used for ISL12026 RTC Clock Control Register for time date read & set
  'The following registers in the RTC range are re-used when not needed for clk
  symbol dBmPrior=w15		'Records previous loop dBm to reduce scrn flicker
  symbol HalfRailCount=w16	'Records half rail reference value
  symbol dBr=w17			'current value of peaking reading in dBr
  symbol var4=b36			'used in dBmtoWatts conversion
  symbol var5=b37			'used in dBmtoWatts conversion
  'end RTC register range
  symbol Watts=w19		'current value of power reading in Watts b38 & b39
  symbol ReturnToMeasureFromLoRf=b40'Flag to sense Sw3 pushed when in LoRf subroutine
'housekeeping & Cal
  symbol dBm_w=b41		'0=display dBm, 1=display Watts
  symbol ATR=b42			'ISL12026 RTC Analog Trim Register
  symbol DTR=b43			'ISL12026 RTC Analog Trim Register
  symbol MeasMode=b44		'Meas mode
  'measurement mode 0=full scale 1=Autorange 2=Peaking
  symbol TempThresh=b45		'Temperature Alarm thrshold 
  symbol ZerodBm=b46		'0.0dBm raw A-D value  
  symbol AttenState=b47		'Attenuator state 1=on 0=off
  symbol AttenValu=w24		'Attenuator value in fromat xx.xdB b48,b49
  symbol Sf=w25			'scale factor for high power tracking b51 50
  symbol SfP=w26			'scale factor for Peaking mode 8xGain b52 53
  symbol BkLiteLevel=w27	'sets display backlight LED brightness b54 55
  
Initialize:
  high shdn,fan,wpEEPROM,gainvcc 'keep unit powered and configure outputs
  low intvcc 'turn on the RF detector,Vref,input voltage divider
  hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte  'configure I2C display
  hi2cout ($00,$39,$14,$70,$5e,$6b,$0c,$06,$01) 'initialize display
  gosub SplashScreen
  pause 1000 'allows supply to stabilize before addressing clock & give some time to read screen.
  let adcsetup=%0100000010101010'removes digital input from ADC converters used
  pokesfr $22,4	'for C.0 fw - issue after adcsetup to fix V+ reference bug
  gosub ReadCCR 'read in clock data from ISL12026 clock control register
  if b35<10 then'Clock data is corrupt year is <2010 so...
    gosub WriteCCR 'kick the clock to start it, won't be right time but 
    hi2cout $0035,(20)'off timer will work...wirte year 2020
  endif
  'Load in existing calibration and Housekeeping registers from ISL12026 EEPROM
  'Get EEPROM TurnOffInt,BkLiteLevel,MeasMode,AttenState,AttenValu,TempThreshold,ZerodBm,Sf,SfP,dBm_W from EEPROM
  hi2cin [$ae],$0000,(TurnOffInterval,b54,b55,MeasMode,AttenState,b48,b49,TempThresh,ZerodBm,b50,b51,b52,b53,dBm_W)
  pwmout bklite,249,BkLiteLevel 'set backlight to stored level
  'now that housekeeping defaults have been loaded...setup interrupt driven tasks
  hi2csetup i2cmaster,$9a,i2cfast_8,i2cbyte'change back to byte from word
  hi2cout 1,(%00011010) 'init MCP9800 config register
  'config reg=continous read;9b ADC;6readings faultQ;AlrtPol active lo;Int mode
  'hi2cout 3,(TempThresh,0) 'set MCP9800 temperature alarm register
  TempthreshMinusHysteresis=TempThresh-3'define hysteresis threshold 3degC less than temp alarm
  'hi2cout 2,(var1,0) 'set MCP9800 temperatue hysteresis register  
  gosub ManageSoftOff'enable clock alarm for HW interrupt if <170
  gosub IncOffTime 'increment off time as defined by TurnOffInterval
  If MeasMode=2 then 'if in peaking mode then turn on 8x amplifier.
    low gainvcc
  endif
  gosub LoadCGRAM 'special characters for bargraph & battery for NewHaven display
  gosub LoadAntiLogTable 'AntiLog table for dBm to Watts conversion
  gosub GetPowerSymbol 
  'Now that off time and temp are configured enable interrupts.
  hintsetup %00000100 'Enable 20X2 HW Int interrupt2 on falling edge (hint2)
  setintflags %00000100,%00000100 'hint2 unmaks hint2
  
'##########INITIALIZATION COMPLETE....START MEASURING#########################
  	RFMeasure:'Rf measurements start here
  	if MeasMode=0 or MeasMode=1 then
  	   goto ScaledMode
  	else 'measure mode is 2 to goto PeakingMode
  	   goto PeakingMode
  	endif
  	goto RFMeasure

'#############START OF SCALED MODE############################################
ScaledMode:
  dBmPrior=888'forces screen clear when returning from subroutines
  do while sw1=0 and sw2=0 and sw3=0 'look for a switch state change
      gosub ChkTemp
      gosub GetPowerSymbol
      gosub ChkForLoRF
  	    if ReturntoMeasureFromLoRf=1 then 'S3 was pushed while in ChkforLoRf so.
  	         goto Utilities
  	    endif
  	    gosub DetectorRawtodBm'gets dBm reading
  	    'The following is used to minimize display flicker only updating the display
          'if the dBm value changes.  All entries to the RFMeasure routine must
  	    'set dBmPrior to 888 to insure the screen is rewritten.  This includes dBm to
  	    'watts conversion & return from utilities.
  	    if dBmPrior<>dBm then'if dBm hasn't changed from last loop don't clear display
  	        gosub ClearDisplay
  	    endif	
  	    gosub WriteDisplayDataArea 'writes dsiplay data in dBm or Watts
  	    if MeasMode=0 then
  	          gosub FullRange
  	        elseif MeasMode=1 then
  	          gosub Autorange 'selects range and wirtes bargraph & header
  	    endif
  	dBmPrior=dBm 
  loop 'until a switch is pushed
  gosub IncOffTime 'moved into test for off 
  if Sw1=1 then 'determine if held for >1second if so turn unit off
      gosub TestForOff
    elseif Sw2=1 then
  	if dBm_W=0 then
  	      dBm_W=1
  	    else dBm_W=0
  	endif
  	dBmPrior=888'rem display only cleared if dBm changes so force a change
      gosub UnlockISL12016EEPROM:
      hi2cout [$ae],$000d,(dBm_W)'save in housekeeping
      gosub LockISL12016EEPROM
      pause 300 'EEPROM takes 25ms but need to get finger off switch2 also
    elseif Sw3=1 then
      goto Utilities
  endif  
goto ScaledMode 'loop back to start of scaled measurements

TestForOff:'If Sw1 pressed for one second or more the unit is turned off
  'Leases
  'var1 - loop counter
   for var1=0 to 9
      pause 100
        if SW1=0 then goto EndTestForOff
    next var1
      goto PwrOff
  EndTestForOff:
  gosub IncOffTime'placed here rather than in subs that call it.  
return

'##############START PEAKING MODE############################################
PeakingMode:'displays amplified 3dBr window to.01dB along with bargraph & dBm
'Leases
'var2 - flag to bypass auto zero
'var3 flag for negative sign for dbm/dbr routine
'var4 - keeps track of pot setting
'varw10 word reading for display decimal conversion
'varw11 intermediate value for scaled numbers
'varw12 8x gain out
'varw13 reference for dBr readings
  low gainvcc ' turn on 8x gain amplifier
  var2=0 'if 1 bypass auto zero
  dBr=333'force find half rail on start
  dBrInnerLoop:    
  do 'does one loop first then loops if conditions true
  	gosub GetPowerSymbol
  	gosub ChkTemp'checks RF load temperature
  	gosub ChkForLoRf
  	if ReturnToMeasureFromLoRf=1 then'Sw3 was pressed while in LoRf so go to Utilities	    
  	    goto Utilities
  	endif
  	hi2cout($80,$8d,$40,"dBr")
      if AttenState=1 then'if the attenuator mode is on
            hi2cout($80,$84,$40,"AdBm") 
        else
            hi2cout($80,$84,$40,"dBm ") 
      endif	
      readadc10 5,varw10 'read 8362 raw out
      gosub DetectorRawtodBm
      gosub decimal
      if var3=" " then'change display fromat between + & - nos.
      'used to cram a negative number into the 4 allocated spaces knowing that
      'all negative numbers are single digit ien -9.9dBm.
          hi2cout ($80,$80,$40,hundred,ten,".",unit)'pos dBm reading
        else  
          hi2cout ($80,$80,$40,var3,ten,".",unit)'neg dBm reading
      endif
        	if dBr>300 and var2=0 then'if dbr overrange and autorange on
  	  gosub FindHalfRail
  	endif
      gosub GainBlkRawtodBr
      gosub decimal  
      hi2cout ($80,$88,$40,var3,hundred,".",ten,unit)'rel reading to display
      gosub WritePeakingBargraph
      'gosub ChkForLoRf'used for 
  loop while sw3=0 and sw1=0 
  gosub IncOffTime
  if sw1=1 then
      gosub TestforOff
      pause 600
      goto dBrInnerloop
    elseif sw3=1 then
      gosub ClearDisplay
      hi2cout ($80,$80,$40,$7f,"Re-center")
      hi2cout ($80,$c0,$40,$7f,"Autocenter ")
      if var2=0 then
             hi2cout ($4c,"Off")
         else
             hi2cout ($4c,"On ")
      endif
      pause 600 'allow time to get finger off of sw3
          gosub WaitForSwitch
          'gosub IncOffTime'a switch was pushed
            if sw1=1 then
                dbr=333 'force find half rail
                goto dBrInnerLoop
              elseif sw2=1 then
                var2=inv var2 'toggle var2 between 0&255 more code efficient
                goto dBrInnerLoop
              elseif Sw3=1 then
  			high gainvcc ' turn off 8x amplifier supply 
			goto Utilities
		endif
  endif
     
WritePeakingBargraph:
#rem
A separate routine is needed for peaking as the trick used to reduce display 
flicker, not changing the display unless the power level changes, won't work 
in peaking as the one hundredth of a dB reading typically varies +/-1 count 
often. The process used writes the display once in each do loop cycle without
first clearing it. Whole blocks (5bars) are written, then any partial block, 
then the remainder of the second line is wrtten with blank characters 
to clear any previous wites as the power level changes.
The bargraph uses all 16 display characters. Zero is mid scale, -3 and +3dBr are
the 8 character end points.
The 16 characters provide resolution for 80bars or 0.075dB per bar
To scale the dBr value to optimize resolution dBr is multiplied by 26.The 
objective is to keep the product under 65K and 8xxxxx but use as high
a multiplier as possible to maintain accuracy and resolution while maintaining
simplicity. 26x300=7800, close enough to 8000, but under so the display won't
wrap around itself (27x300=8100=trouble). The sf is actually 3.08dB or
.0769dB per bar.
#endrem 
'Leases
'var1 - loop control to write characters 
'var5 - rounds last digit for 1-5 bar display
'varw11 -interim product number of whole blocks
'varw12 -value of partial block 1 to 4 elements
'varw13 - number of blocks
hi2cout($80,$c0) 'set display to start of line 2  
if var3=" " then'if value is positive
   varw13=dBr*26+8000'number of full blocks
   if varw13>16000 then'limit display when Autocenter is off
     varw13=16000
   endif
   else'dBr is negative so subtract from mid span
   varw13=dBr*26
   varw13=8000-varw13
   if varw13>8000 then'limit display when Autocenter is off
    varw13=0
   endif
endif
varw11=varw13/1000'no of whole blocks
if varw11<>0 then'if 0 don't wirte anything, messes up location otherwise
    for var1=1 to varw11
      hi2cout($40,5)'write whole blocks to display
    next var1
endif
varw12=varw13//1000/200'partial blocks, in all cases a char is written evenif blank
  if varw12<>0 then
    hi2cout ($40,varw12)'write to display char containing 1-4 bars
    else
    hi2cout($40,$a0)'write a blank character to the display
  endif
  inc varw11'move the character to be written over one position on the display
  for var1=varw11 to 16
    hi2cout ($40,$a0)'write blank characters to the remainder of the line
  next var1
  return     
  
FindHalfRail:'Changes MCP4018 Pot acting as D-A to find 512 bits at PICAXE A-D
'output on PICAXE A-D to optimize dynamic range of the MC7101
'8x gain amplifier for peaking mode measurements
'Leases
'var4 - stores Pot setting
var4=64'set pot to half full value to minimize search time.
StartFindHalfRail:
  readadc10 7,HalfRailCount 'read 8xgain out
  if HalfRailCount <487 and var4>0 then
      dec var4
    elseif HalfRailCount >537 and var4<127 then
      inc var4
    elseif HalfRailCount >=487 and HalfRailCount <=537 then
      goto EndFindHalfRail
  endif
  hi2cout [$5e],(var4) 'change pot
  goto StartFindHalfRail
EndFindHalfRail:
return

GainBlkRawtodBr:'meausers 8x gain block output & returns dBr
'Leases
'var3 - sign flag
'var4 - used to round scaled number
'varw10 - number to be used for display
'varw11 intermediate value for scaled numbers
'varw12 - raw 8x Gain number
  readadc10 7,varw12 'read raw 8xgain value
  varw10=varw12-HalfRailCount 'difference between half rail and current reading
  if varw10>1023 then 'if number is negative 2's compliment and flag sign
      varw10=inv varw10+1
      var3=1
    else
      var3=0
  endif
    'now multiply the positive signed number by SfP the peaking scale factor.  
  'varw13=SfP 'transfer peaking scale factor to var13
  varw13=SfP'scale using Peaking scale factor
  gosub ScaleNumber
  dBr=w10'keep dBr in global variable
  'scaled number is retured in varw10,and sign is in var3
return

DetectorRawtodBm:'measures detector output and returns dBm
'Leases
'var1 'used to store rounding value
'var3 'used to indicate negative number for decimal routine
'varw10 'delivers scaled number to other routines
'varw12 'delivers a negative number to the bargraph routine
'varw13 used to deliver Sf to scale factor routine.
'AD8362 detector output is 50mV/dB or 500mV per dB decade.
'Measurement resolution is 4mV per bit (4.096 ref/1024 steps)=125steps/decade
'The -10 to +50 dBm range results in 750 steps.
'To scale this to 600 steps (0.1dB per step) multiply by 0.8
'To set the resulting number referenced to zero dB subtact the measured 
'0dB reading raw measurment value.
  readadc10 5,varw10 'read 8362 out
  if varw10<ZerodBm then
    read varw10,varw10'if below 0dBm replace with EEPROM corrected value  
  endif
  varw10=varw10-ZerodBm
  if varw10>1024 then 'no is negative so take two's compliment and flag sign
       varw10=inv varw10+1
       var3=1 'set negative number flag
     else 
       var3=0 'flags that number is positive
  endif
  'now scale the number by multiplying it by Sf
  varw13=sf
  gosub ScaleNumber
  if AttenState=1 then 'if attenuator is on
    if var3=1 then 'and if the number is negative
      varw10=inv varw10+1+AttenValu 'then adjust for attenuator value
        if varw10>1024 then 'and with attenuator if the number is still negative
          varw10=inv varw10+1'do a two's compliment and maintain var3=1
        else     'or 
          var3=0 'with attenuator on the reading is now positive
        endif
    else
      varw10=varw10+AttenValu 'adjust reading for attenuator value
    endif
  endif
  dbm=varw10'also store result in dBm
  'results in a 3 digit scaled number with attenuator offset xx.xdBm   
return

ScaleNumber:
'Leases
'var1 used to parse remainder
'varw11 intermediate stores partially scaled number
'varw13 holds scale factor on entry and scaled number on exit
  varw11= varw13 dig 0 * varw10/10
  varw11= varw13 dig 1 * varw10 + varw11
  varw11= varw13 dig 2 * varw10 * 10 + varw11
  var1=varw11 dig 1
  varw10=varw11/100
  if var1 >4 then 'round the result to three digits
    inc varw10
  endif
return

WriteDisplayDataArea:
'The 4 left most characters on both lines are reserved for numeric display data
'line 1 contains the power heading; dBm uW, mW, or W and A if the Attenuator is on
'line 2 contains the value in -xx.x format for dbm and xxxx for watts
  if AttenState=1 then
       hi2cout [$7c],($80,$8c,$40,"A")
     else
       hi2cout ($80,$8c,$40," ")
  endif
  if dBm_W=1 then
       gosub dBmtoWatts 'write reading in Watts
    else
       hi2cout ($80,$8d,$40,"dBm")
       varw10=dBm
       gosub decimal
       hi2cout ($80,$cc,$40,hundred,ten,".",unit)
       if var3="-" then'value is negative
              hi2cout ($80,$cc,$40,"-")'saves a display space as >-10not allowed
       endif
   endif
return

'######...dBm TO WATTS CONVERSION ROUTINE BEGINS HERE...######    
dBmtoWatts:'for detailed explanation see dBm to Watts Conversion.bas
  'in brief dBm value in the form xx.xdBm, actually xxx.
  'Special handling is provided for negative numbers, -10.0 to -0.1dBm 
  'Antilog values are found for the tens and units and multiplied together
  'Scaling is done using the hundreds value.
  'Watts display both title (uW,mW,W) & value is also handled in this section    
  'Leases
  'var1 - holds dBm most significant digit for multiplication.
  'var2 - multiple uses
  'var3 - used to flag negative no.
  'var4 - used in antilog calc
  'var5 - used in altilog calc
  'ten  - dig valu if dBm
  'varw10 - final value & sent to Decimal routine for dsiplay parsing
  'varw11 - intermediate values
  'varw12 - stores dBm valu so it isn't changed if negative otherwise buggers bargraph neg nos.
  'Rem dBm readings range 000-700,viewed as xx.xdBm
   varw12=dBm
   if var3=1 then 'no. is negative handle the negative -10.0dBm to -0.1dBm range
      varw12=100-varw12 'subtract 10dBm from reading
   endif
   ten=varw12 dig 1'parse the xx.xdBm units value..in the tens position
   get ten,var2 'get the first byte of the second digit word
   var5=ten+10 'index to get the second byte if the two byte multiplier
   get var5,var4 'get the second byte
   Varw11=var2+var4 'put the word together from the two bytes
   unit=varw12 dig 0'parse the xx.xdBm tent's unit value...in units position
   unit=unit+20 'pointer to antilog table entry
   get unit,var2
   varw11=varw11*var2 'multipy the tens and units values together
   if ten > 7 then 'check if unit was 8 or 9...both require *2.
        varw10=varw11 / 10 * 2 '/10 then *2 to keep result <65535)
      else
        varw10=varw11/10 'make number less than 10k for display proc. convenience
   endif
   'The watts value is now in the form xxxx
   if var1<6 then 'if reading is less than 1000 then round dig 1 for 3 digit display
       var2=varw10 dig 0'parse the LSB to determine if value should be rounded up  
       if var2>=5 then
           varw10=varw10+10 'round up the result rather than truncate
       endif
   endif
   gosub Decimal 'parse watts reading into ascii for display
   'now display the top and bottom lines
   var1=varw12 DIG 2'parse most significant digit to determine the magnitude
   if var3="-" then 'top line display
           hi2cout ($80,$8d,$40,"uW")
       elseif var1=0 or var1=1 or var1=2 then
   	     hi2cout ($80,$8d,$40,"mW")
       elseif var1>2 then
   	     hi2cout ($80,$8e,$40,"W")
   endif
   hi2cout($80,$cc)'set display locaton for readout
   if var3="-" or var1=2 or var1=5 then 'bottom line display
   	     hi2cout ($40," ",thousand,hundred,ten) 'display reading 
       elseif var1=1 or var1=4 then
   	     hi2cout ($40,thousand,hundred,".",ten) 'display reading
   	 elseif var1=0 or var1=3 then           
           hi2cout ($40,thousand,".",hundred,ten) 'display reading
       elseif var1>5 then
           hi2cout ($40,thousand,hundred,ten,unit) 'display reading
   endif
return

'############ BARGRAPH DISPLAY #######################################
FullRange:'displays -10 to 50,60 or 70dBm bargraph
'Leases
'var2 'contains attenuator tens digit value
'varw12 -is used by WriteBargraph
WriteBargraphLegend:
  'adjust full scale range to suit external attenuator
  var2=AttenValu dig 2 'get the value of attenuator 'tens'.
	hi2cout ($80,$80)'set display to line 1 pos 1.
     if AttenState=1 and var2=1 or var2=2 then
       hi2cout ($40,"10  30    60")
     elseif AttenState=1 and var2>2 then
       hi2cout ($40,"20  40    70")
     else
       hi2cout ($40," 0  20    50")     
  endif
  hi2cout ($80,$88,$40,PowerSymbol) 'add Power Symbol     
  gosub WriteBargraph  
return

AutoRange:'displays -10 to 70dBm in seven ranges
'Leases
'varw13 also WriteBargraph -used to create bargraph for each range
StartAutoRange:
    range=dBm dig 2 'selects hundres value from randomnolo
    rangelo=range*100-18
    if rangelo>700 then 'rangelo became negative 
      rangelo=0
    endif
    rangehi=range*100+100
    varw13=dbm-rangelo+2
    hi2cout ($80,$80)'set display to line1 char1 
    if var3="-" then
     		hi2cout ($40," -9  -5 ",PowerSymbol," -0")  
     	elseif range=0 then
     		hi2cout ($40," 0    5 ",PowerSymbol," 10")
     	elseif range=1 then
     	    	hi2cout ($40,"10   15 ",PowerSymbol," 20")
     	elseif range=2 then
    		hi2cout ($40,"20   25 ",PowerSymbol," 30")
    	elseif range=3 then
    	      hi2cout ($40,"30   35 ",PowerSymbol," 40")
    	elseif range=4 then
    	      hi2cout ($40,"40   45 ",PowerSymbol," 50")
    	elseif range=5 then
            hi2cout ($40,"50   55 ",PowerSymbol," 60")
      elseif range=6 then
            hi2cout ($40,"60   65 ",PowerSymbol," 70")
    endif
    gosub WriteBargraph    	     	   
return
  
WriteBargraph:
'Leases
'var1 - loop control to write whole characters 
'var2 - carried in from FullScale subroutine, identifies Atten tens digit
'var5 - rounds last digit for 1-5 bar display
'varw12 -number of whole digits & bars to write NB  b18=LSByte varw12
'varw12 - carries in the negative reading in dBm
'varw13 - comes from Autorange contains no from 2-120 full digit=10units each bart=2units
    hi2cout($80,$c0) 'set display to start of line 2
  if MeasMode=0 then 'in full range
    if var3="-" then 'if the reading is negative
        varw12=inv dBm +101/50 'if negative take two's compliment+100.
      elseif AttenState=1 and var2=1 or var2=2 then 'var2 is dig2 of attenuator (>10dB) 
        varw12=dBm/50
      elseif AttenState=1 and var2>2 then
        varw12=dBm-100/50
      else
        varw12=dBm+100/50 'no of full blocks display is offset by 10 so 0 is -10dbm
    endif
  else'in autorange so
      if var3="-" then'no is negative
          varw12=inv dBm +101 dig 1 +2
        else
          varw12= dbm dig 1 +2 
      endif
  endif  
  if varw12>0 and varw12<12 then 'only wirte if full blocks needed.
  'capped the number of whole blocks written to 12 as display was being
  'filled with blocks very occasionally when transitioning from full range
  'mode to LoRf subroutine.
    for var1=1 to varw12
      hi2cout($40,5)'write whole blocks to display
    next
  endif
  if MeasMode=0 then 'full range
    if var3="-" then
        varw12=inv dBm+101//50 'find the remainder of two's compliment if negative
      else
        varw12=dBm//50
    endif
    var5=varw12 dig 0
    if var5 >4 then 'round the last digit for the display
      varw12=varw12+10
    endif
    varw12=varw12 dig 1  'find no of char elements to draw values 1 to 4   
  else'in autorange
    if var3="-" then
          varw12=inv dBm +101 dig 0 /2
       else
          varw12=dBm dig 0 /2 'autorange & each element=2units
    endif
  endif
  if varw12<>0 then 'dont' wirte anything if only whole chars to be written
    hi2cout ($40,varw12)'write to display char containing 1-4 bars
  endif
  EndWriteBargraph:
  return



'###################### UTILITIES SECTION #################################
Utilities: '0=MeasMode 1=SelOffInterval 2=TempAlarm 3=ChgHrMin 4=PwrOff
  'displays main title on the display line 1 and menu itmes on line 2
  'pressing S1 increments menu choice, S2 decrements menu choice, S3 selects
'Leases
  'None
  ReturnToMeasureFromLoRF=0'more code efficient here than in 2 statemts that
  'direct here 
  gosub ClearDisplay
  MainMenuItem=0	'keeps track of menu items with this variable; init to 0
  MainMenuInnerMenuLoop:
  gosub MainMenuLine1Title 'write main title to display...used many times
  gosub DisplayUpDn'displys Up or Dn opposite S1 and S2
  if MainMenuItem=0 then 
    gosub DisplayDn 'at top of menu items so remove Up.
  endif
  hi2cout ($80,$c3)'set display for start most menu itmes to save code 
  on MainMenuItem gosub MenuSetMeasMode,MenuSetAttenuator,MenuSetOffInterval,MenuSetBacklight,MenuSetTempAlarm,MenuChangeHrMin,MenuPwrOff
  pause 300 'wait a bit so display can be viewed
  gosub WaitForSwitch
  gosub IncOffTime
  if sw1=1 and MainMenuItem >0 then
      dec MainMenuItem
    elseif sw2=1 and MainMenuItem<6 then 'max count is menu items less 1 
      inc MainMenuItem
    elseif Sw3=1 then
      pause 400 'give a bit of time to get finger off of the select button
      on MainMenuItem gosub SetMeasMode,SetAttenuator,SetOffInterval,SetBacklight,SetTempAlarm,ChangeHour,PwrOff
      pause 400 'give a bit of time to get finger off switch
      goto EndMainMenuLoop 'returned fro subroutine so go back to measuring RF
  endif
    goto MainMenuInnerMenuLoop
  EndMainMenuLoop:
  gosub IncOffTime
  goto RFMeasure

MenuSetMeasMode: 'sets RF measurement mode
  hi2cout ($40,"Set Meas Mode")
return
MenuSetAttenuator:
  hi2cout ($40,"Attenuator   ")'sets state ON/OFF and atten value
return
MenuSetOffInterval:'sets time increment before unit is turned off 
  hi2cout ($40,"Off Iterval")
return
MenuSetBacklight: 'set backlight level
  hi2cout ($40,"Backlight  ")
return
MenuSetTempAlarm: 'sets over temperatue alarm threshold
  hi2cout ($40,"Temp Alarm ")
return
MenuChangeHrMin: 'sets clock to account for osc errors DST time change
  hi2cout ($40,"Change Hour")
return
MenuPwrOff:
  hi2cout ($80,$c0,$40,"   Power Off   ")'last menu item so overwrite Dn
return
MainMenuLine1Title:
   hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte  'configure I2C display
   hi2cout ($80,$83,$40,"SL Utilities ")'write MainMenu header
return 

SetMeasMode:
'Leases
'None
  gosub ClearDisplay
  hi2cout ($80,$83,$40,"Measure Mode")'write MainMenu header
  SubMenuItem=MeasMode 'set initial submenu item to current mode
  InnerMeasMode:
  gosub DisplayUpDn
  if SubMenuItem=0 then
    gosub DisplayDn 'at top of menu items so remove up
  endif
  hi2cout ($80,$c3)'set display to line 1char 3 for submenus saves code
  on SubMenuItem gosub MenuFullScale,MenuAutorange,MenuPeaking
  pause 300 'wait a bit so display can be viewed if sw1 or 2 is held down  
  gosub WaitForSwitch
  if sw3=1 then
      'pause 300 'give a bit of time to get finger off of the select button
      MeasMode=SubmenuItem 'update measurement mode
      gosub UnlockISL12016EEPROM:
      hi2cout [$ae],$0003,(MeasMode)
      gosub LockISL12016EEPROM
      goto ExitMeasMode
    elseif sw1=1 and SubMenuItem >0 then
      dec SubMenuItem
    elseif sw2=1 and SubMenuItem <2 then 'max count is menu items less 1 
      inc SubMenuItem
  endif
  goto InnerMeasMode
 ExitMeasMode:
return

MenuFullScale: 'sets RF measurement mode
  hi2cout ($40,"Full Scale")
return
MenuAutorange: 
  hi2cout ($40,"Auto Scale")
return
MenuPeaking:
  hi2cout ($80,$c0,$40,"   Peaking   ")
return


SetAttenuator:'set attenuator off / on and then if on set level in xx.xdBm
  'Leases
  'varw10 temp stores atten value
  gosub SetFeatureOff_ON
  if sw1=1 then
      AttenState=0
    elseif sw2=1 then 'get atten value from user, start with current valu
      AttenState=1
      gosub ClearDisplay
  	hi2cout($80,$83,$40,"Atten Value")
  	gosub DisplayUPDn
  	pause 300 'wait some time to get your finger off of the switch
  	InnerAttenValu:
  	varw10=AttenValu
  	gosub decimal
  	hi2cout($80,$c3,$40,hundred,ten,".",unit,"dB")
  	  gosub WaitForSwitch
  	  pause 70 'provide some time to get finger off switch if held
  	  if sw1=1 and AttenValu<411 then'upper atten limit 41dB
  	      inc AttenValu
  	    elseif Sw2=1 and AttenValu>19 then 'lower atten limit 2dB
  	      dec AttenValu
  	    elseif Sw3=1 then
  	      goto EndSetAttenuator
  	  endif
  	 goto InnerAttenValu:	
  endif
  EndSetAttenuator:
    gosub UnlockISL12016EEPROM:
    hi2cout [$ae],$0004,(AttenState,b48,b49) 'write backlight value
    gosub LockISL12016EEPROM 
return

SetFeatureOff_On:'used on Atten and SetOffLevel to choose whether the feature is off or on
  gosub ClearDisplay
  hi2cout($80,$80,$40,$7f,"Set Off")
  hi2cout($80,$c0,$40,$7f,"Set On")
  gosub WaitForSwitch
return

SetOffInterval:
'Leases
'varw10-passes info to decimal for display
  gosub SetFeatureOff_On
  if sw1=1 then 
      TurnOffInterval=255
    elseif sw2=1 then'get value of off interval from user start with stored vaule or default 10min.
      gosub ClearDisplay
      gosub DisplayUpDn
      hi2cout ($80,$83,$40,"Off Interval")'write MainMenu header
      if TurnOffInterval>170 then 
        TurnOffInterval=10'default to 10min if interval was off.
      endif
      pause 300 'give a bit of time to get finger off sw2 before gong into set mode.
      InnerOffInterval:
      varw10=TurnOffInterval
      gosub decimal
      hi2cout ($80,$c3,$40,ten,unit," min")  
      gosub WaitForSwitch
      pause 150 'give a bit of time to get finger off of the select button
      if sw1=1 and TurnOffInterval <59 then
          inc TurnOffInterval
        elseif Sw2=1 and TurnOffInterval >2 then 
          dec TurnOffInterval
        elseif Sw3=1 then
          goto ExitOffInterval
       endif
      goto InnerOffInterval     
   endif'go to exit if Sw3=1
 ExitOffInterval:
      gosub UnlockISL12016EEPROM:
      hi2cout [$ae],$0000,(TurnOffInterval)
      gosub LockISL12016EEPROM
      gosub ManageSoftOff'enable ISL12026 alarm if TurnOffInterval<170
      gosub IncOffTime 'invokes new off time on exit so not relying on future sw push.
return

SetBacklight: 'set backlight level
'Leases
'var1 used in Decimal subroutine
'var2 backlight current
'varw10 used in Decomal subrouting
'var12 backlight EEPROM address
  gosub ClearDisplay
  hi2cout ($80,$83,$40,"Chg Backlight")'write MainMenu header
  gosub DisplayUpDn
  varw12=$0070'initialize address at start of backlight data
  InnerSetBacklight:
  pause 300 'wait a bit so display can be viewed if sw1 or 2 is held down
  hi2csetup i2cmaster,$ae,i2cfast_8,i2cword 'set to EEPROM
  hi2cin varw12,(b54,b55,var2) 'get backlight level & current
  pwmout bklite,249,BkLiteLevel 'set backlight to new level using PWM
  varw10=BkLiteLevel
  gosub decimal
  hi2cout ($80,$c3,$40,hundred,ten,unit)'write backlight PWM value
  varw10=var2
  gosub decimal
  hi2cout ($80,$c8,$40,hundred,ten,".",unit,"mA")'write MainMenu header 
  gosub WaitForSwitch
  if sw1=1 and varw12 < $009d then
      varw12=varw12+3
    elseif sw2=1 and varw12 > $0070 then 
      varw12=varw12-3
    elseif sw3=1 then
      goto ExitSetBacklight
  endif
  goto InnerSetBacklight
 ExitSetBacklight:
   gosub UnlockISL12016EEPROM:
   hi2cout [$ae],$0001,(b54,b55) 'write backlight value
   gosub LockISL12016EEPROM
return

SetTempAlarm:
'Leases
'varw10 used for decimal
  gosub ClearDisplay
  hi2cout ($80,$83,$40,"Set Temp Alrm")'write MainMenu header
  gosub DisplayUpDn
  InnerTempAlarm: 
  varw10=TempThresh
  gosub decimal
  hi2cout ($80,$c3,$40,ten,unit,$df,"C")  
  gosub WaitForSwitch
  pause 150 'provide a bit of time to view the display if button is held down
  if sw1=1 and TempThresh <55 then
        inc TempThresh
     elseif sw2=1 and TempThresh > 30 then
        dec TempThresh
     elseif Sw3=1 then
        goto ExitTempAlarm
  endif
  goto InnerTempAlarm
 ExitTempAlarm:
      gosub UnlockISL12016EEPROM:
      hi2cout [$ae],$0007,(TempThresh)
      gosub LockISL12016EEPROM
      'this code set the MCP9800 but leave at 80&75 defaults for now
      'hi2csetup i2cmaster,$9a,i2cfast_8,i2cbyte  'configure Temp Sensor
      'hi2cout 3,(TempThresh,0) 'set MCP9800 temperature alarm register
      'var1=TempThresh-2'define hysteresis threshold 2degC less than temp alarm
      'hi2cout 2,(var1,0) 'set MCP9800 temperatue hysteresis register
return

ChangeHour:
  'Leases
  'varw10 holds hour data (b32)
  gosub ReadCCR
  var1=b32
  var1=var1 & %01111111 'get rid of 24hr 'Mil' bit
  gosub ClearDisplay
  hi2cout ($80,$85,$40,"Chg Hr")
  gosub DisplayUpDn
  InnerSetHour:
    gosub BCD2ascii'REM hours are saved in BCD format
    hi2cout($80,$c7,$40,ten,unit)'write hours to display
    var2=var1 & %00001111 'set trap for BCD counter
    gosub WaitForSwitch
    if Sw1=1 and var1<$24 then
        if var2=9 then 
          var1=var1+7
        else
          inc var1
        endif
      elseif Sw2=1 and var1>$0 then 
        if var2=0 then
          var1=var1-7
        else
          dec var1
        endif
      elseif sw3=1 then
        goto EndSetHour
    endif
  pause 300  
  goto InnerSetHour
EndSetHour:
  var1=var1 or %10000000 'add back in 24hr 'Mil' bit
  b32=var1     
  gosub ReadCCR
  gosub WriteCCR
  hi2cout $0030,(b30,b31,b32,b33,b34,b35,b36,b37) 
return

GetPowerSymbol:
  readadc 3,var1 'read the 4:1 battery voltage
  if var1>=105 then 'input is greater than 6.8V
      PowerSymbol=$1b 'AC mains symbol
    elseif var1>=78 then 'half charge battery threshold
      PowerSymbol=$07 'full battery
    elseif var1>=73 then 'low battery threshold
      PowerSymbol=$06 'half battery symbol
    else
      PowerSymbol=$00 'empty battery symbol
  endif
return

IncOffTime: 'adds TurnOffInterval to current Alarm1 register time
'REM NO LEASES -this routine can be used just about anywhere
'Call this routine anywhere a switch is pushed to redefine turn off time
  if TurnOffInterval>170 then 'Turn off interval is set off so bypass increment
    goto EndIncOffTime
  endif
  hi2csetup i2cmaster,$de,i2cfast_8,i2cword 'Clock Register
  hi2cin $0031,(OffTime) 'read RTC minutes register
  OffTime=bcdtobin OffTime +TurnOffInterval 'convert to bin & add TurnOffInterval 
  if OffTime>59 then'value is into next hour so... 
    OffTime=OffTime-60 'sets proper alarm time if OffTime into next hour
  endif
  OffTime=bintobcd OffTime or %10000000 'convert to BCD & enable MNA1 alarm bit
  gosub WriteCCR  'preamble to enable write to RTC registers
  hi2cout $0009,(OffTime) 'write new time into Alarm1 register CCR done by ManageSoftOff
  pause 25 'CCR EEPROM write takes 20ms min before I2C buss is released
  EndIncOffTime:  
  hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte  'configure I2C display 
  'as the typical return point will use this device next. 
return 

LoadCGRAM:'Load NewHaven CGRAM from the ISL12026 RTC EEPROM
  hi2csetup i2cmaster,$ae,i2cfast_8,i2cword 'set to EEPROM
  hi2cin $002f,(var2) 'set the address to the byte before start of CGRAM    
  hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte 'set to display
  hi2cout ($00,$38,$40)	'set instruction table lo to write CGRAM & set address  
for var1=0 to 63 'load 64bytes of CGRAM  into the display CGRAM memory
  hi2csetup i2cmaster,$ae,i2cfast_8,i2cword'set to EEPROM
  hi2cin (var2)
  hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte'set to NewHaven display
  hi2cout ($40,var2)
  next var1
hi2cout ($00,$39)	'set NewHaven display instruction table back to hi 
return

LoadAntiLogTable:
#rem
Used to convert dBm to Watts
All readings are stored as dBm in the format xx.xdBm, xxx actually
This table will provide power for any input value from -10 to +69.9dBm
Table accuracy in .1dB steps - mean is .09% with a standard deviation of 0.36%
The anitlog table is stored in thirty bytes
The multiplier -1 to +6 (for -10 to +69.9dBm) is not stored.
The second digit 0-9 is stored as two bytes0-9 and 10-19 to contanin word values. The multiplier is the sum of the two bytes. To find the total add the numbers using 'digit'command for the first then add ten to the digit value to get the second register.
The thrid digit 0-9 is never more than 255 so it is stored as a signle byte in the location 20-29.
#endrem
  hi2csetup i2cmaster,$ae,i2cfast_8,i2cword 'set to EEPROM
  hi2cin $000f,(var2) 'set the address to the byte before start of CGRAM
  for var1=0 to 29
    hi2cin (var2)
    put var1,var2
  next var1
return

SplashScreen:
  hi2cout($40,"CleverLoad V0.4")'cursor is at home pos so write first line
  hi2cout($80,$c0,$40,"Wayne 6132257989")'cursor to start of 2nd line & write
return

ClearDisplay:
  hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte  'configure I2C display
  hi2cout ($80,$01) 'clear display
  pause 1
return

DisplayUpDn:'These three subroutines simplify Up and Dn writes to display
  hi2cout ($80,$80,$40,"Up ") 'display up and down on display lines 1 & 2
  hi2cout ($80,$c0,$40,"Dn ")
return
'DisplayUp:'insufficient code space use bkanks in front of last menu choice
'  hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte  'configure I2C display
'  hi2cout ($80,$80,$40,"Up ") 'display up and blank on display lines 1 & 2
'  hi2cout ($80,$c0,$40,"   ")
'return
DisplayDn:
  hi2cout ($80,$80,$40,"   ") 'display blank & down on display lines 1 & 2
return    
    
Decimal: 'parses varw10 either positive or negative no. & converts for display
  'Leases
  'var1 - contains sign in ASCII
  'var3 - used to flag negative numbers
  'varw10 - numeric power value to be written to dispaly
   if var3=1 then
    var3="-"
    else
    var3=" "
  endif 
  unit=varw10 dig 0 + "0"	'format for display by taking each digit to be displayed
  ten=varw10 dig 1 + "0"	'and placing it in a variable for use with the hi2cout command
  hundred=varw10 dig 2 + "0"
  thousand=varw10 dig 3 + "0"
  hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte'likely sending to display so... 
return

WriteCCR:'enables ISL12026 CCR write
  hi2csetup i2cmaster,$de,i2cfast_8,i2cword 'Clock Register
  hi2cout [$de],$003f,($02) 'write 2 then 6 to config register to enable writes
  hi2cout [$de],$003f,($06)'Clock Control Register writes now enabled
return

UnlockISL12016EEPROM:
  gosub WriteCCR
  hi2cout $0010,(%00000000) 'unprotect all EEPROM blocks-should be default but... 
  pause 25 'Wait time for EEPROM wirte during this period I2C buss not available 
return

LockISL12016EEPROM: 'enable EEPROM block protection
  gosub WriteCCR
  hi2cout $0010,(%11100000) 'protect all EEProm blocks
  pause 25'Wait time for EEPROM wirte during this period I2C buss not available
return 

WaitForSwitch:
  do while sw1=0 and sw2=0 and sw3=0 'look for a switch state change
  loop 'until a switch is pushed
return

ChkForLoRf: 'routine detects low RF and sticks until RF available for processing
'Leases
'varw10 stores raw power reading
  readadc10 5,varw10 'read 8362 output
 if varw10 < 50 then 'Rf is less than -10dBm.
    gosub ClearDisplay
    hi2cout($80,$80,$40,"Lo")
    hi2cout($80,$c0,$40,"RF")
    do while varw10<50 and Sw1=0 and Sw3=0
        gosub ReadCCR
        gosub DisplayDMY
        gosub DisplayHMS
        gosub GetPowerSymbol
        gosub UpdateTemperature
        gosub DisplayTemperature
        hi2cout ($80,$84,$40,PowerSymbol)
        readadc10 5,varw10 'read 8362 output
    loop
  endif

  if Sw1=1 then
      gosub TestForOff
      goto ChkForLoRF 
    elseif Sw3=1 then
      ReturnToMeasureFromLoRf=1 'flag to go to utilities program rather than just back to ChkForLoRF  
  endif
  EndChkForLoRF:
return 

ReadCCR:
  hi2csetup i2cmaster,$de,i2cfast_8,i2cword 'Clock Register
  hi2cin $0030,(b30,b31,b32,b33,b34,b35,b36,b37)
return

DisplayHMS: 'REM HH:mm:ss converted from BCD displayed at end of line 1.
'would normally write ss:mm:HH but this order reduces I2C code
    var1=b32 'get hours
    var1=var1 & %01111111 'get rid of 24hr 'Mil' bit
    gosub BCD2ascii
    hi2cout($80,$88,$40,ten,unit)'write hours to display
    var1=b31 'get minutes
    gosub BCD2ascii
    hi2cout($40,":",ten,unit) 'write minutes
    var1=b30 'get seconds
    gosub BCD2ascii:
    hi2cout ($40,":",ten,unit)'wirte seconds
 return
 
BCD2ascii: 'conversion takes 12 lines of code so subroutine is smaller 
 bcdtoascii var1,ten,unit 'when used just a couple times.
return
BIN2ascii:
 bintoascii var1,hundred,ten,unit
return

DisplayDMY: 'DD/MM/YY converted from bin displayed at end of line2
    var1=b33 'days
    gosub BIN2ascii
    hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte   
    hi2cout($80,$c8,$40,ten,unit)
    var1=b34 'months
    gosub BIN2ascii
    hi2cout($40,"/",ten,unit) '
    var1=b35 'years
    gosub BIN2ascii
    hi2cout ($40,"/",ten,unit)
 return
  
UpdateTemperature:	'REM the 9800 updates 9bit temp every 30 ms.
  hi2cin [$9a],0,(Temp)	'address 9800 & read in register bytes
  if Temp>127 then	'temp is below 0degc, so two's compliments req'd.
    Temp=Temp-128		'do a simple 2's compliment calculation
      var3=1		'set var3 to - for decimal subroutine
    else
      var3=0		'value is positive
  endif
return

DisplayTemperature:
varw10=Temp'get value of temp into varw10 for decimal
gosub decimal
  hi2cout [$7c],($80,$c2,$40,var3,ten,unit,$df,"C")'display result
return
 
PwrOff:
  gosub ClearDisplay
  hi2cout ($80,$86,$40,"Bye")
  hi2cout ($80,$c6,$40,"Bye")
  pause 1000'wait a bit for the button to be released or unit will repower
  low shdn
  pause 1000
return

ManageSoftOff:'manages soft switch Enables or disables ISL12026 alram O/P
    gosub WriteCCR
    if TurnOffInterval<170 then 'enable ISL12026 alarm & interrupt
        hi2cout $0011,(%11000000) 'IM on enable Alarm1 Osc O/P
      else 		'TurnOffInterval set to off so disable alarm
        hi2cout $0011,(%10000000) 'IM on disable Alarm1 Osc O/P
    endif
    pause 25 'CCR EEPROM write takes 20ms min before I2C buss is released
return

ChkTemp:'put here as the interrupt was return from interrupt just too hard
'Leases
'None
  gosub UpdateTemperature
  if Temp<=TempthreshMinusHysteresis then
    EscapeTempAlarm=0'reset the escape
  endif
if Temp<TempThresh or EscapeTempAlarm=1 then
  goto EndChkTemp'temperature is below threshold so continue
endif
'the only way to get here is if the temp sensor is hot 
  gosub ClearDisplay
    do'loop until the unit cools or excape clause
       gosub DetectorRawtodBm'gets dBm reading
       gosub WriteDisplayDataArea
       if varw10>99 and var3="-" then
          hi2cout ($80,$cc,$40,"LoRF")
       endif   
       gosub UpdateTemperature 'returns var1 or varw10 with temp valu & writes display
       gosub DisplayTemperature
       hi2cout ($80,$81,$40,"HOT! HOT!") 'write alrarm on first line	     
       pwmout bklite,249,001'set backlight full brightness
       pause 200
       pwmout bklite,249,990'set backlight to near off brightenss  
       pause 200
    loop while Sw3=0 and Temp>TempThreshMinusHysteresis 'keep blinking the display while HOT!
   'added Sw3 to the loop as an escape as thermal time constant
   'is quite long so this allows exit but input power SHOULD BE REDUCED.
   if Sw3=1 then
     EscapeTempAlarm=1
     pause 300 'provide a little time to get finger off the button
   endif
   pwmout bklite,249,BkLiteLevel'restore backlight level
   gosub ClearDisplay
EndChkTemp:
hi2csetup i2cmaster,$7C,i2cfast_8,i2cbyte'resume writing display
return


Interrupt:'Hardware Int handling routine for Clock & Temp alarm
  gosub PwrOff
  'hint2flag=0 'reset hint2flag
  'setintflags %00000100,%00000100 'set int2, unmaks int2
 return 'no need to be tidy about returning from interrupt device will be off



